const Pending = require("../models/Pending");
const asyncHandler = require("../middleware/async");
const ErrorResponse = require("../utils/errorResponse");
const fetch = require("node-fetch");
const {
  createTruck,
  addGroup,
  createBussinessMan,
  createTransport,
  createLineMaker,
} = require("../utils/request");

// ! OK
exports.requestGroup = asyncHandler(async (req, res, next) => {
  const findFirst = await Pending.find({
    $and: [{ "user._id": req.user._id }, { group: req.body.group }],
  });

  console.log("findFirst", findFirst);
  if (findFirst.length) {
    return next(new ErrorResponse("You have already requested", 401));
  }
  // ! to pennding haye user toye group bayad begardam agar group ba group darkhasti dasht
  // ! error bedam ke ghablan vase in darkhast zadi
  const {
    group,
    companyName,
    companyLicensePhoto,
    companyAddress,
    idCardPhoto,
    idCard,
    truckType,
    truckPlate,
    truckPlatePhoto,
    transportCapacity,
    profileCompany,
    depositAmount,
    businessMan,
  } = req.body;

  console.log("req.bodyyyyyyy", req.body);

  const user = {
    _id: req.user._id,
    username: req.user.username,
    pictureProfile: req.user.pictureProfile,
  };
  console.log("user>>>>>>>>>>>>>>>", user);

  if (group == "lineMaker") {
    const findBuss = await Pending.findById(businessMan);

    // console.log("findBuss<<<<<<<<<<<<", findBuss);

    // const body = {
    //   group: find.group,
    // };

    const resultAddGroup = await addGroup(req.user._id, group);

    const createZ = await Pending.create({
      user,
      group,
      companyName,
      companyAddress: findBuss.companyAddress,
      idCardPhoto,
      idCard,
      profileCompany,
      businessMan: {
        _id: findBuss.user._id,
        pendingId: findBuss._id,
        group: findBuss.group,
        companyName: findBuss.companyName,
        profileCompany: findBuss.profileCompany,
      },
      status: 1,
    });

    // console.log("creaeteeeeeeeeeeeee", createZ);

    // console.log("toooooooooooooooooshhhhhhhhhh");

    const data = {
      group: createZ.group,
      companyName: createZ.companyName,
      companyAddress: findBuss.companyAddress,
      idCard: createZ.idCard,
      idCardPhoto: createZ.idCardPhoto,
      profileCompany: createZ.profileCompany,
      businessMan: createZ.businessMan,
      user: createZ.user,
    };

    const result = await createLineMaker(data);

    return res.status(200).json({
      success: true,
      data: {},
    });
  }

  const create = await Pending.create({
    user,
    group,
    companyName,
    companyLicensePhoto,
    companyAddress,
    idCardPhoto,
    idCard,
    truckType,
    truckPlate,
    truckPlatePhoto,
    transportCapacity,
    profileCompany,
    depositAmount,
    deposit: depositAmount ? true : false,
    status: 0,
  });

  res.status(200).json({
    success: true,
    data: {},
  });
});

// OK
exports.allRequestMe = asyncHandler(async (req, res, next) => {
  const all = await Pending.find({
    "user._id": req.user._id,
  });

  res.status(200).json({
    success: true,
    data: all,
  });
});

// ADMIN
// OK
exports.approveRequest = asyncHandler(async (req, res, next) => {
  // ! to pennding haye user toye group bayad begardam agar group ba group darkhasti dasht
  // ! error bedam ke ghablan vase in darkhast zadi

  const find = await Pending.findOne({
    invoiceNumber: req.params.invoiceNumber,
  });
  console.log(find.group);
  const body = {
    group: find.group,
  };

  const resultAddGroup = await addGroup(find.user._id, body);

  if (resultAddGroup) {
    await find.updateOne({
      status: 1,
    });

    if (find.group == "truck") {
      const data = {
        group: find.group,
        companyName: find.companyName,
        companyLicensePhoto: find.companyLicensePhoto,
        companyAddress: find.companyAddress,
        idCard: find.idCard,
        idCardPhoto: find.idCardPhoto,
        truckType: find.truckType,
        truckPlate: find.truckPlate,
        truckPlatePhoto: find.truckPlatePhoto,
        transportCapacity: find.transportCapacity,
        profileCompany: find.profileCompany,
        deposit: find.deposit,
        depositAmount: find.depositAmount,
        user: find.user,
      };

      const resultCreateTruck = await createTruck(data);
    }

    if (find.group == "commerce") {
      const data = {
        group: find.group,
        companyName: find.companyName,
        companyLicensePhoto: find.companyLicensePhoto,
        companyAddress: find.companyAddress,
        idCard: find.idCard,
        idCardPhoto: find.idCardPhoto,
        profileCompany: find.profileCompany,
        user: find.user,
      };

      const resultCreateTruck = await createBussinessMan(data);
    }

    if (find.group == "transport") {
      const data = {
        group: find.group,
        companyName: find.companyName,
        companyLicensePhoto: find.companyLicensePhoto,
        companyAddress: find.companyAddress,
        idCard: find.idCard,
        idCardPhoto: find.idCardPhoto,
        profileCompany: find.profileCompany,
        user: find.user,
      };

      const resultCreateTruck = await createTransport(data);
    }

    res.status(200).json({
      success: true,
      data: {},
    });
  }
});

exports.reject = asyncHandler(async (req, res, next) => {
  const find = await Pending.findOne({
    invoiceNumber: req.params.invoiceNumber,
  });

  await find.updateOne(
    {
      status: 2,
    },
    { new: true }
  );

  res.status(200).json({
    success: true,
    data: {},
  });
});

exports.allPending = asyncHandler(async (req, res, next) => {
  const all = await Pending.find({ status: 0 });

  res.status(200).json({
    success: true,
    data: all,
  });
});
