const mongoose = require("mongoose");
const ShortUniqueId = require("short-unique-id");
const { signF } = require("../utils/sign");

const PendingSchema = new mongoose.Schema(
  {
    user: {
      _id: { type: mongoose.Schema.ObjectId },
      username: { type: String },
      pictureProfile: { type: String },
      phone: { type: String },
    },

    group: {
      type: String,
    },

    idCardFront: {
      type: String,
    },

    idCardBack: {
      type: String,
    },

    educationalLicense: {
      type: String,
    },
    // ! ta inja

    // ID USERI
    businessMan: {
      _id: { type: mongoose.Schema.ObjectId },
      pendingId: { type: mongoose.Schema.ObjectId },
      group: { type: String },
      companyName: { type: String },
      profileCompany: { type: String },
    },

    companyName: {
      type: String,
    },

    companyLicensePhoto: {
      type: String,
    },

    companyAddress: [
      {
        address: { type: String },
        nameAddress: { type: String },
        latitude: { type: Number },
        longitude: { type: Number },
        target: { type: Number },
        city: { type: String },
        province: { type: String },
        district: { type: String },
        street: { type: String },
        country: { type: String },
        streetNumber: { type: String },
        _id: false,
      },
    ],

    idCard: {
      type: Number,
    },

    idCardPhoto: {
      type: String,
    },

    truckType: {
      type: Number,
    },

    truckPlate: {
      type: String,
    },

    truckPlatePhoto: {
      type: String,
    },

    transportCapacity: {
      type: Number,
      max: 32,
    },

    profileCompany: {
      type: String,
    },

    deposit: {
      type: Boolean,
      default: false,
    },

    depositAmount: {
      type: Number,
    },

    // 0 == pennding
    // 1 == approve
    // 2 == reject
    status: {
      type: Number,
    },

    invoiceNumber: {
      type: String,
    },
  },
  { timestamps: true }
);

PendingSchema.post("find", async function (result) {
  await result.map(async (item) => {
    if (item.idCardFront && item.idCardFront.length) {
      const res = await signF(item.idCardFront);
      item.idCardFront = res;
    }
    if (item.idCardBack && item.idCardBack.length) {
      const res = await signF(item.idCardBack);
      item.idCardBack = res;
    }
    if (item.companyLicensePhoto && item.companyLicensePhoto.length) {
      const res = await signF(item.companyLicensePhoto);
      item.companyLicensePhoto = res;
    }

    if (item.profileCompany && item.profileCompany.length) {
      const res = await signF(item.profileCompany);
      item.profileCompany = res;
    }

    if (item.truckPlatePhoto && item.truckPlatePhoto.length) {
      const res = await signF(item.truckPlatePhoto);
      item.truckPlatePhoto = res;
    }

    if (item.idCardPhoto && item.idCardPhoto.length) {
      const res = await signF(item.idCardPhoto);
      item.idCardPhoto = res;
    }
  });
});

PendingSchema.pre("save", async function (next) {
  const uid = await new ShortUniqueId({ length: 8 });

  this.invoiceNumber = await uid();
});
module.exports = mongoose.model("Pending", PendingSchema);
// xxxxxxxxxxxxxxxxxxxxxxxx
