const express = require("express");

const C = require("../controllers/approve");

const { protect } = require("../middleware/auth");

const router = express.Router();

// POST

router.post("/request", protect, C.requestGroup);

router.get("/approverequest/:invoiceNumber", protect, C.approveRequest);

router.get("/reject/:invoiceNumber", protect, C.reject);

router.get("/allrequestme", protect, C.allRequestMe);

router.get("/allpendings", C.allPending);

module.exports = router;
